/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class ItemEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> f_31984_ = SynchedEntityData.m_135353_(ItemEntity.class, EntityDataSerializers.f_135033_);
    private static final int f_149659_ = 6000;
    private static final int f_149660_ = Short.MAX_VALUE;
    private static final int f_149661_ = Short.MIN_VALUE;
    public int f_31985_;
    public int f_31986_;
    private int f_31987_ = 5;
    @Nullable
    private UUID f_31988_;
    @Nullable
    private UUID f_31982_;
    public final float f_31983_;
    public int lifespan = 6000;
    private int lastTick = MinecraftServer.currentTick - 1;

    public ItemEntity(EntityType<? extends ItemEntity> p_31991_, Level p_31992_) {
        super(p_31991_, p_31992_);
        this.f_31983_ = this.f_19796_.nextFloat() * (float)Math.PI * 2.0f;
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
    }

    public ItemEntity(Level p_32001_, double p_32002_, double p_32003_, double p_32004_, ItemStack p_32005_) {
        this(p_32001_, p_32002_, p_32003_, p_32004_, p_32005_, p_32001_.f_46441_.nextDouble() * 0.2 - 0.1, 0.2, p_32001_.f_46441_.nextDouble() * 0.2 - 0.1);
    }

    public ItemEntity(Level p_149663_, double p_149664_, double p_149665_, double p_149666_, ItemStack p_149667_, double p_149668_, double p_149669_, double p_149670_) {
        this((EntityType<? extends ItemEntity>)EntityType.f_20461_, p_149663_);
        this.m_6034_(p_149664_, p_149665_, p_149666_);
        this.m_20334_(p_149668_, p_149669_, p_149670_);
        this.m_32045_(p_149667_);
        this.lifespan = p_149667_.m_41720_() == null ? 6000 : p_149667_.getEntityLifespan(p_149663_);
    }

    private ItemEntity(ItemEntity p_31994_) {
        super(p_31994_.m_6095_(), p_31994_.f_19853_);
        this.m_32045_(p_31994_.m_32055_().m_41777_());
        this.m_20359_(p_31994_);
        this.f_31985_ = p_31994_.f_31985_;
        this.f_31983_ = p_31994_.f_31983_;
    }

    @Override
    public boolean m_142050_() {
        return this.m_32055_().m_204117_(ItemTags.f_144322_);
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void m_8097_() {
        this.m_20088_().m_135372_(f_31984_, ItemStack.f_41583_);
    }

    @Override
    public void m_8119_() {
        if (this.m_32055_().onEntityItemUpdate(this)) {
            return;
        }
        if (this.m_32055_().m_41619_()) {
            this.m_146870_();
        } else {
            double d0;
            int i;
            super.m_8119_();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.f_31986_ != Short.MAX_VALUE) {
                this.f_31986_ -= elapsedTicks;
            }
            if (this.f_31985_ != Short.MIN_VALUE) {
                this.f_31985_ += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            float f = this.m_20192_() - 0.11111111f;
            if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)f) {
                this.m_32067_();
            } else if (this.m_20077_() && this.m_204036_(FluidTags.f_13132_) > (double)f) {
                this.m_32068_();
            } else if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            if (this.f_19853_.f_46443_) {
                this.f_19794_ = false;
            } else {
                boolean bl = this.f_19794_ = !this.f_19853_.m_45756_(this, this.m_142469_().m_82406_(1.0E-7));
                if (this.f_19794_) {
                    this.m_20314_(this.m_20185_(), (this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0, this.m_20189_());
                }
            }
            if (!this.f_19861_ || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_142049_()) % 4 == 0) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
                float f1 = 0.98f;
                if (this.f_19861_) {
                    f1 = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_())).getFriction((LevelReader)((Object)this.f_19853_), new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), this) * 0.98f;
                }
                this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
                if (this.f_19861_) {
                    Vec3 vec31 = this.m_20184_();
                    if (vec31.f_82480_ < 0.0) {
                        this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = Mth.m_14107_((double)this.f_19854_) != Mth.m_14107_((double)this.m_20185_()) || Mth.m_14107_((double)this.f_19855_) != Mth.m_14107_((double)this.m_20186_()) || Mth.m_14107_((double)this.f_19856_) != Mth.m_14107_((double)this.m_20189_());
            int n = i = flag ? 2 : 40;
            if (this.f_19797_ % i == 0 && !this.f_19853_.f_46443_ && this.m_32070_()) {
                this.m_32069_();
            }
            this.f_19812_ |= this.m_20073_();
            if (!this.f_19853_.f_46443_ && (d0 = this.m_20184_().m_82546_(vec3).m_82556_()) > 0.01) {
                this.f_19812_ = true;
            }
            ItemStack item = this.m_32055_();
            if (!this.f_19853_.f_46443_ && this.f_31985_ >= this.f_19853_.spigotConfig.itemDespawnRate) {
                int hook = ForgeEventFactory.onItemExpire((ItemEntity)this, (ItemStack)item);
                if (hook < 0) {
                    this.m_146870_();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item.m_41619_()) {
                if (CraftEventFactory.callItemDespawnEvent((ItemEntity)this).isCancelled()) {
                    this.f_31985_ = 0;
                    return;
                }
                this.m_146870_();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.f_31986_ != Short.MAX_VALUE) {
            this.f_31986_ -= elapsedTicks;
        }
        if (this.f_31985_ != Short.MIN_VALUE) {
            this.f_31985_ += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.f_19853_.f_46443_ && this.f_31985_ >= this.f_19853_.spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent((ItemEntity)this).isCancelled()) {
                this.f_31985_ = 0;
                return;
            }
            this.m_146870_();
        }
    }

    private void m_32067_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
    }

    private void m_32068_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    private void m_32069_() {
        if (this.m_32070_()) {
            double radius = this.f_19853_.spigotConfig.itemMerge;
            for (ItemEntity itementity : this.f_19853_.m_6443_(ItemEntity.class, this.m_142469_().m_82377_(radius, radius - 0.5, radius), p_186268_ -> p_186268_ != this && p_186268_.m_32070_())) {
                if (!itementity.m_32070_()) continue;
                this.m_32015_(itementity);
                if (!this.m_146910_()) continue;
                break;
            }
        }
    }

    private boolean m_32070_() {
        ItemStack itemstack = this.m_32055_();
        return this.m_6084_() && this.f_31986_ != Short.MAX_VALUE && this.f_31985_ != Short.MIN_VALUE && this.f_31985_ < 6000 && itemstack.m_41613_() < itemstack.m_41741_();
    }

    private void m_32015_(ItemEntity p_32016_) {
        ItemStack itemstack = this.m_32055_();
        ItemStack itemstack1 = p_32016_.m_32055_();
        if (Objects.equals(this.m_32056_(), p_32016_.m_32056_()) && ItemEntity.m_32026_(itemstack, itemstack1)) {
            ItemEntity.m_32017_(this, itemstack, p_32016_, itemstack1);
        }
    }

    public static boolean m_32026_(ItemStack p_32027_, ItemStack p_32028_) {
        if (!p_32028_.m_150930_(p_32027_.m_41720_())) {
            return false;
        }
        if (p_32028_.m_41613_() + p_32027_.m_41613_() > p_32028_.m_41741_()) {
            return false;
        }
        if (p_32028_.m_41782_() ^ p_32027_.m_41782_()) {
            return false;
        }
        if (!p_32027_.areCapsCompatible(p_32028_)) {
            return false;
        }
        return !p_32028_.m_41782_() || p_32028_.m_41783_().equals(p_32027_.m_41783_());
    }

    public static ItemStack m_32029_(ItemStack p_32030_, ItemStack p_32031_, int p_32032_) {
        int i = Math.min(Math.min(p_32030_.m_41741_(), p_32032_) - p_32030_.m_41613_(), p_32031_.m_41613_());
        ItemStack itemstack = p_32030_.m_41777_();
        itemstack.m_41769_(i);
        p_32031_.m_41774_(i);
        return itemstack;
    }

    private static void m_32022_(ItemEntity p_32023_, ItemStack p_32024_, ItemStack p_32025_) {
        ItemStack itemstack = ItemEntity.m_32029_(p_32024_, p_32025_, 64);
        if (!itemstack.m_41619_()) {
            p_32023_.m_32045_(itemstack);
        }
    }

    private static void m_32017_(ItemEntity p_32018_, ItemStack p_32019_, ItemEntity p_32020_, ItemStack p_32021_) {
        if (CraftEventFactory.callItemMergeEvent((ItemEntity)p_32020_, (ItemEntity)p_32018_).isCancelled()) {
            return;
        }
        ItemEntity.m_32022_(p_32018_, p_32019_, p_32021_);
        p_32018_.f_31986_ = Math.max(p_32018_.f_31986_, p_32020_.f_31986_);
        p_32018_.f_31985_ = Math.min(p_32018_.f_31985_, p_32020_.f_31985_);
        if (p_32021_.m_41619_()) {
            p_32020_.m_146870_();
        }
    }

    @Override
    public boolean m_5825_() {
        return this.m_32055_().m_41720_().m_41475_() || super.m_5825_();
    }

    @Override
    public boolean m_6469_(DamageSource p_32013_, float p_32014_) {
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return false;
        }
        if (this.m_6673_(p_32013_)) {
            return false;
        }
        if (!this.m_32055_().m_41619_() && this.m_32055_().m_150930_(Items.f_42686_) && p_32013_.m_19372_()) {
            return false;
        }
        if (!this.m_32055_().m_41720_().m_41386_(p_32013_)) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)this, (DamageSource)p_32013_, (double)p_32014_)) {
            return false;
        }
        this.m_5834_();
        this.f_31987_ = (int)((float)this.f_31987_ - p_32014_);
        this.m_146852_(GameEvent.f_157808_, p_32013_.m_7639_());
        if (this.f_31987_ <= 0) {
            this.m_32055_().onDestroyed(this, p_32013_);
            this.m_146870_();
        }
        return true;
    }

    @Override
    public void m_7380_(CompoundTag p_32050_) {
        p_32050_.m_128376_("Health", (short)this.f_31987_);
        p_32050_.m_128376_("Age", (short)this.f_31985_);
        p_32050_.m_128376_("PickupDelay", (short)this.f_31986_);
        p_32050_.m_128405_("Lifespan", this.lifespan);
        if (this.m_32057_() != null) {
            p_32050_.m_128362_("Thrower", this.m_32057_());
        }
        if (this.m_32056_() != null) {
            p_32050_.m_128362_("Owner", this.m_32056_());
        }
        if (!this.m_32055_().m_41619_()) {
            p_32050_.m_128365_("Item", this.m_32055_().m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag p_32034_) {
        this.f_31987_ = p_32034_.m_128448_("Health");
        this.f_31985_ = p_32034_.m_128448_("Age");
        if (p_32034_.m_128441_("PickupDelay")) {
            this.f_31986_ = p_32034_.m_128448_("PickupDelay");
        }
        if (p_32034_.m_128441_("Lifespan")) {
            this.lifespan = p_32034_.m_128451_("Lifespan");
        }
        if (p_32034_.m_128403_("Owner")) {
            this.f_31982_ = p_32034_.m_128342_("Owner");
        }
        if (p_32034_.m_128403_("Thrower")) {
            this.f_31988_ = p_32034_.m_128342_("Thrower");
        }
        CompoundTag compoundtag = p_32034_.m_128469_("Item");
        this.m_32045_(ItemStack.m_41712_(compoundtag));
        if (this.m_32055_().m_41619_()) {
            this.m_146870_();
        }
    }

    @Override
    public void m_6123_(Player p_32040_) {
        if (!this.f_19853_.f_46443_) {
            if (this.f_31986_ > 0) {
                return;
            }
            ItemStack itemstack = this.m_32055_();
            Item item = itemstack.m_41720_();
            int i = itemstack.m_41613_();
            int canHold = p_32040_.m_150109_().canHold(itemstack);
            int remaining = i - canHold;
            if (this.f_31986_ <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.m_41764_(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((org.bukkit.entity.Player)p_32040_.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.f_19853_.getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.m_41764_(i);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((org.bukkit.entity.Player)p_32040_.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.f_19853_.getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.m_41764_(i);
                    return;
                }
                ItemStack current = this.m_32055_();
                if (!((Object)((Object)itemstack)).equals((Object)current)) {
                    itemstack = current;
                } else {
                    itemstack.m_41764_(canHold + remaining);
                }
                this.f_31986_ = 0;
            } else if (this.f_31986_ == 0) {
                this.f_31986_ = -1;
            }
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)this, (Player)p_32040_);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.m_41777_();
            if (this.f_31986_ == 0 && (this.f_31982_ == null || this.lifespan - this.f_31985_ <= 200 || this.f_31982_.equals(p_32040_.m_142081_())) && (hook == 1 || i <= 0 || p_32040_.m_150109_().m_36054_(itemstack))) {
                copy.m_41764_(copy.m_41613_() - this.m_32055_().m_41613_());
                ForgeEventFactory.firePlayerItemPickupEvent((Player)p_32040_, (ItemEntity)this, (ItemStack)copy);
                p_32040_.m_7938_(this, i);
                if (itemstack.m_41619_()) {
                    this.m_146870_();
                    itemstack.m_41764_(i);
                }
                p_32040_.m_6278_(Stats.f_12984_.m_12902_(item), i);
                p_32040_.m_21053_(this);
            }
        }
    }

    @Override
    public Component m_7755_() {
        Component component = this.m_7770_();
        return component != null ? component : new TranslatableComponent(this.m_32055_().m_41778_());
    }

    @Override
    public boolean m_6097_() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerLevel p_32042_, ITeleporter teleporter) {
        Entity entity = super.changeDimension(p_32042_, teleporter);
        if (!this.f_19853_.f_46443_ && entity instanceof ItemEntity) {
            ((ItemEntity)entity).m_32069_();
        }
        return entity;
    }

    public ItemStack m_32055_() {
        return this.m_20088_().m_135370_(f_31984_);
    }

    public void m_32045_(ItemStack p_32046_) {
        this.m_20088_().m_135381_(f_31984_, p_32046_);
        this.m_20088_().markDirty(f_31984_);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_32036_) {
        super.m_7350_(p_32036_);
        if (f_31984_.equals(p_32036_)) {
            this.m_32055_().m_41636_(this);
        }
    }

    @Nullable
    public UUID m_32056_() {
        return this.f_31982_;
    }

    public void m_32047_(@Nullable UUID p_32048_) {
        this.f_31982_ = p_32048_;
    }

    @Nullable
    public UUID m_32057_() {
        return this.f_31988_;
    }

    public void m_32052_(@Nullable UUID p_32053_) {
        this.f_31988_ = p_32053_;
    }

    public int m_32059_() {
        return this.f_31985_;
    }

    public void m_32060_() {
        this.f_31986_ = 10;
    }

    public void m_32061_() {
        this.f_31986_ = 0;
    }

    public void m_32062_() {
        this.f_31986_ = Short.MAX_VALUE;
    }

    public void m_32010_(int p_32011_) {
        this.f_31986_ = p_32011_;
    }

    public boolean m_32063_() {
        return this.f_31986_ > 0;
    }

    public void m_149678_() {
        this.f_31985_ = Short.MIN_VALUE;
    }

    public void m_32064_() {
        this.f_31985_ = -6000;
    }

    public void m_32065_() {
        this.m_32062_();
        this.f_31985_ = this.f_19853_.spigotConfig.itemDespawnRate - 1;
    }

    public float m_32008_(float p_32009_) {
        return ((float)this.m_32059_() + p_32009_) / 20.0f + this.f_31983_;
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public ItemEntity m_32066_() {
        return new ItemEntity(this);
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.AMBIENT;
    }
}

